# Llamar a la base de datos
datos<- read.csv2("efem.csv", row.names=1)

str(datos)

#---------
# LIBRERAS REQUERIDAS
library(ellipse)
require(gclus)
require(SciViews)
require(ade4)
require(vegan)
library(gplots)
library(ggplot2)
library(corrplot)
library(factoextra)



#==================================================================
# SIETE (7) TIPOS DE CLUSTERS JERRQUICOS

# PASO 1. Distancia entre observaciones
# Matriz de distancia
d.bray <- vegdist(datos.h, method="bray")
round(d.bray,2)

A<-vegdist(datos.h[1:6, 1:8],method="bray")
round(A,2)

#--------------
# (1) Vecino ms cercano "Cl.single", comando "hclust" y mtodo "single"
Cl.single <- hclust(d.bray,method="single")
# Figura del dendograma generado
x11()
plot	(Cl.single, ylab="Distancia Bray Curtis", cex.lab=1.2,xlab="",
      main="Vecino ms Cercano", cex.main=1.2,col.main=4,cex=0.8, sub="")


# (2) Vecino ms lejano "Cl.complete", funcin "complete"  
Cl.complete<-hclust(d.bray,method="complete")
# Figura del dendograma generado
plot	(Cl.complete, ylab="Distancia Bray Curtis", cex.lab=1.2,xlab="",
      main="Vecino ms Lejano", cex.main=1.2,col.main=4, cex=0.8, sub="")


# (3) UPGMA funcin "average" Unin Promedio no Ponderado
Cl.upgma<-hclust(d.bray,method="average")
# Figura del dendograma generado
plot	(Cl.upgma,ylab="Distancia Bray Curtis", cex.lab=1.2,xlab="", cex=0.8,
      main="Unin Promedio no Ponderada (UPGMA)", cex.main=1.2,col.main=4,
      sub="")

#---------------
x11()
par(mfrow=c(2,2))

# (4) WPGMA funcin "mcquitty"
Cl.wpgma<-hclust(d.bray,method="mcquitty")
plot(Cl.wpgma,ylab="Distancia Bray Curtis",cex.lab=1.2,xlab="",sub="",cex=0.8,
     main="Union Promedio Ponderada (WPGMA)", cex.main=1.2,col.main=4)


# (5) UPGMC funcin "centroid"
Cl.upgmc<-hclust(d.bray,method="centroid")
plot(Cl.upgmc,ylab="Distancia Bray Curtis", cex.lab=1.2,xlab="",sub="",cex=0.8,
     main="Union Centroide no Ponderada (UPGMC)", cex.main=1.2,col.main=4)


# (6) WPGMC funcin "median"
Cl.median<-hclust(d.bray,method="median")
plot(Cl.median,ylab="Distancia Bray Curtis", cex.lab=1.2,xlab="",sub="",cex=0.8,
     main="Unin Centroide Ponderado (WPGMC)", cex.main=1.2,col.main=4)


# (7) WARD, funcin "ward"
Cl.ward<-hclust(d.bray,method="ward.D")
plot(Cl.ward,ylab="Distancia Bray Curtis", cex.lab=1.2,xlab="",sub="",cex=0.8,
     main="Union de Ward (WARD)", cex.main=1.2,col.main=4)

par(mfrow=c(1,1))

#------------------------------------- 
# PAO 2. Seleccionar mejor mtodo de agrupacin
# CORRELACIONES COFENTICAS 

# (1) Correlacin cofentica  para "single"
cofenet1 <- cophenetic(Cl.single)
cor(d.bray,cofenet1)

# (2) Correlacin cofentica  para "complete"
cofenet2<-cophenetic(Cl.complete)
cor(d.bray,cofenet2)

# (3) Correlacin cofentica  para "average"
cofenet3<-cophenetic(Cl.upgma)
cor(d.bray,cofenet3)

# (4) Correlacin cofentica  para "mcquitty"
cofenet4<-cophenetic(Cl.wpgma)
cor(d.bray,cofenet4)

# (5) Correlacin cofentica  para "centroid"
cofenet5<-cophenetic(Cl.upgmc)
cor(d.bray,cofenet5)

# (6) Correlacin cofentica  para "mmedian"
cofenet6<-cophenetic(Cl.median)
cor(d.bray,cofenet6)

# (7) Correlacin cofentica  para "ward"
cofenet7<-cophenetic(Cl.ward)
cor(d.bray,cofenet7)

# data frame con cofenticos
cofeneticos = data.frame(simple=cor(d.bray,cofenet1),compl=cor(d.bray,cofenet2),
                         upgma=cor(d.bray,cofenet3),upgmc=cor(d.bray,cofenet4),
                         wpgma=cor(d.bray,cofenet5),wpgmc=cor(d.bray,cofenet6),
                         ward=cor(d.bray,cofenet7))
cofeneticos

# cofenticos por cada mtodos (Met)
cofenet=data.frame(Met = 1:7,Cofen=t(round(cofeneticos,3)))
cofenet

# tabla con orden descendente de cofenticos
cof_ordenado = cofenet[order(cofenet$Cofen, decreasing = TRUE), ]
cof_ordenado

# guardar tabla como csv
write.csv2(cof_ordenado,"cofenet.csv")



#-------------------------------------
# Figuras correlaciones cofenticas
x11()
par(mfrow=c(2,2))
# (1) distancia cofentica  para "single" 
plot1<-plot(d.bray,cofenet1,
            xlab="Distancia Bray Curtis",ylab="Distancia Cofentica",
            main=c("Unin Simple",paste("Correlacin Cofentica",
                                        round(cor(d.bray,cofenet1),3))))
abline(0,1)
lines(lowess(d.bray,cofenet1),col=2)
# (2) Correlacin cofentica  para "complete"
plot2<-plot(d.bray,cofenet2,
            xlab="Distancia Bray Curtis",ylab="Distancia Cofentica",
            main=c("Unin Completa",paste("Correlacin Cofentica",
                                          round(cor(d.bray,cofenet2),4))))
abline(0,1)
lines(lowess(d.bray,cofenet2),col=2)
# (3) Correlacin cofentica  para "average"
plot3<-plot(d.bray,cofenet3,
            xlab="Distancia Bray Curtis",ylab="Distancia Cofentica",
            main=c("Unin Promedio no Ponderada-UPGMA",paste("Correlacin Cofentica",
                                                             round(cor(d.bray,cofenet3),4))))
abline(0,1)
lines(lowess(d.bray,cofenet3),col=2)
# (4) Ccorrelacin cofentica  para "mcquitty"
plot1<-plot(d.bray,cofenet4,
            xlab="Distancia Bray Curtis",ylab="Distancia Cofentica",
            main=c("Unin Promedio Ponderada-WPGMA",paste("Correlacin Cofentica",
                                                          round(cor(d.bray,cofenet4),3))))
abline(0,1)
lines(lowess(d.bray,cofenet4),col=2)
par(mfrow=c(1,1))



# ------------------------------------------------------------------
# PASO 3. Nmero de grupos formados - Opcin 1 (Niveles de Fusin)

# Base de variables a relacionar (datos)
datos<-datos.h

# Grafico para valores de niveles de fusin
x11()
plot(Cl.upgma$height, nrow(datos):2, type="S", 
     main="Niveles de fusin - Distancia Bray - UPGMA", 
     ylab="k (Nmero de Cluster)", xlab="h (Altura del Nodo)", col="grey")
text(Cl.upgma$height, nrow(datos):2, nrow(datos):2, col="red", cex=0.7)

# La figura muestra el escaln ms prolongado en 2 grupos


# ------------------------------------------------------------------
# PASO 3. Nmero de grupos formados - Opcin 2 (Amplitud de Silueta)
# Nmero optimo de clusters de acuerdo al Ancho de silueta
# ndice de calidad de Rousseeuw      

# 1. Crear un vector vaco (datos.vacio) con asw valores
datos.vacio <- numeric(nrow(datos.h))

# 2. Silueta "sil" 
for(k in 2: (nrow(datos.h)-1)){
  sil <- silhouette(cutree(Cl.upgma,k=k),d.bray)
  datos.vacio[k]<-summary(sil)$avg.width} 

# 3. Mejor o mayor amplitud de silueta (2 particiones)
k.mejor <- which.max(datos.vacio)
k.mejor 

# Grafica de silueta
plot(1:nrow(datos),datos.vacio,type="h",
     main="Silueta - Nmero Optimo de Clusters", xlab="(nmero de grupos)",
     ylab="Amplitud promedio de  silueta")

axis(1,k.mejor,paste("optimo",k.mejor,sep="\n"),col="red",
     font=2,col.axis="red")

points(k.mejor,max(datos.vacio),pch=16,col="red",cex=1.5)

# Insumos numricos del mtodo de silueta
cat("","Silueta - Nmero Optimo de Clster k=",k.mejor,
    "\n","Con una amplitud promedio de silueta=",max(datos.vacio),"\n")




#--------------------------
# PASO 3. Opcin 3 - Mtodo de particin con algoritmo PAM
# Particin de cluster de tipo no jerrquico

source("funcin_silueta.r")

# Figura de Amplitud Promedio de Silueta
x11()
fviz_nbclust(datos.h, FUN = pam, method = "silhouette") +
  theme_classic()

# Resultados del algoritmo PAM
pam.res <- pam(datos.h, 3)
print(pam.res)

# Mxima amplitud de silueta promedio
max.sil= pam.res$silinfo$avg.width
max.sil

# Grupos formados
k.mejor = pam.res$call$k
k.mejor

# Insumos numricos del mtodo de silueta
cat("","Silueta - Nmero Optimo de Clster k=",k.mejor,
    "\n","Con una amplitud promedio de silueta=",max.sil,"\n")


# Visualizacin del cluster del algoritmo PAM
x11()
fviz_cluster(pam.res,
             palette = c("#00AFBB", "#FC4E07", "#E7B800"), # Paleta de colores
             ellipse.type = "t", # Grafica de elipses
             repel = TRUE, # elimina rotulos solapados en la figura
             ggtheme = theme_classic())



#-----------------------------
# PASO 3. Otros mtodos basados en particiones jerrquicas

# 1. Promedio de siluetas
x11()
# Opcin 1
fviz_nbclust(datos.h, FUN = hcut, method = "silhouette")
# Opcin 2
fviz_nbclust(datos.h, FUN = kmeans, method = "silhouette")+
  labs(subtitle = "Mtodo de Silueta")


# 2. Mtodo de codo
# Opcin (conociendo al nmero de k grupos)
fviz_nbclust(datos.h, kmeans, method = "wss") +
  geom_vline(xintercept = 3, linetype = 2)+
  labs(subtitle = "Mtodo de Codo")


# 3. Estadstica con intervalos
# Opcin 1
gap_stat <- clusGap(datos.h, FUN = hcut, nstart = 25, K.max = 10, B = 50)
fviz_gap_stat(gap_stat)

# Opcin 2 (conociendo al nmero de k grupos)
set.seed(123)
fviz_nbclust(datos.h, kmeans, nstart = 25, method = "gap_stat", nboot = 50)+
  labs(subtitle = "Mtodo de Intervalos")




# -------
# Dendograma final
# Figura
x11()
plot (Cl.upgma,ylab="Distancia Bray Curtis", 	# Rotulo de la distancia
      cex.lab=1.2,xlab="",			# tamao del texto de los ejes
      main="Union Promedio no Ponderada (UPGMA)", 	# Rotulo de ttulo
      cex.main=1,			# tamao del texto del ttulo
      sub="",hang=-1, cex=0.7)   	# hang= -1 para alinear las ramas      
rect.hclust(datos.upgma,k=3,border = 2)	# Rectngulos de cada grupo

# Opcin 2
fviz_dend(Cl.upgma, k = 3,              # k grupos
          cex = 0.5,                    # tamao del texto de las observaciones
          ylab = "Distancia Bray Curtis",	# Rotulo de la distancia
          main = "Unin Promedio no Ponderada (UPGMA)",	# Rotulo de ttulo
          lower_rect = 0,			# Inicio de los rectngulos en cero
          k_colors = c("#2E9FDF","#00AFBB","#FC4E07"),
          color_labels_by_k = TRUE,    # Colores para cada grupo
          rect = TRUE)                 # Rectngulos de cada grupo

# Add rectangle around groups

# Opcin 3 (Clster no jerrquico)
grp <- cutree(Cl.upgma, k = 3)           # Grupos generados "grp"	
fviz_cluster(list(data = datos.h, cluster = grp),
             palette = c("#2E9FDF", "#00AFBB", "#FC4E07"),  # Colores para cada grupo
             ellipse.type = "convex",          # Elpses
             repel = TRUE,                 # Eliminar solapamiento de observaciones
             show.clust.cent = FALSE,      # Muestra a los clster centrados
             ggtheme = theme_minimal())	



#------------------------
# PASO 4. Variables que mejor clasifican (Mapas de Calor)

# Base de datos sin row.names=1
datos1<-read.csv2("efem.csv")	# Llamar nuevamente la base de datos sin row.names=1
str(datos1)	# Estructura de la base de datos.

# Transformacin de Hellinger (datos.h), para linealizar a las variables
datos.h=decostand(datos1[,c(5:12)],method="total")

# Seleccin de las variables cuantitativas en formato matricial       
datos2<-as.matrix(datos.h)
round(datos2,2)

# Seleccin de la primera columna para graficar a las observaciones (tramos y muestreos)
rownames(datos2)<-datos1[,1]
round(datos2,2)

# 1. Mapa de calor por cada observacin, con el paquete stats
hv <- heatmap(datos2, margins=c(6,5), xlab ="Taxones de Efemerpteros", 
              ylab= "Tramos y muestreos en el Ro", main = "Caracterizacin de Tramos",
              scale = "column",distfun = vegdist, method="average")


help(heatmap)



#-----------------
# 2. Mapa de calor para los promedios de cada tramo del ro.
datos<-read.csv2("efem.csv", row.names=1)	# Llamar a la base de datos con row.names=1
datos<-na.exclude(datos)
attach(datos)

# Transformacin de Hellinger (datos.h), para linealizar a las variables
datos.h=decostand(datos[,c(4:11)],method="total")

# Clculo de las medias para cada tramo del ro
datos1<- aggregate(datos.h,na.rm=TRUE, 
                   by=list(Tramo=datos$TRAMO),mean)

# Seleccin de las variables cuantitativas en formato matricial       
datos2<-as.matrix(datos1[,2:9])
round(datos2,2)

# Seleccin de la primera columna para graficar a las observaciones (tramos)
rownames(datos2)<-datos1[,1]
round(datos2,2)		# Visualizacin de los datos

#--------------
# 1. Mapa de calor con los promedios de abundancia por tramos - paquete vegan
x11()
hv <- heatmap(datos2, margins=c(6,5), distfun = vegdist,
              xlab ="Taxones de Efemerpteros", 
              ylab= "Tramos del Ro", main = "Caracterizacin de Tramos")    



#--------------
# 2. Mapa de calor con los promedios de abundancia por tramos - paquete gplots
dev.new(title = "Mapa de calor",width = 10,noRStudioGD = TRUE)
x11()
hclust.ave <- function(datos2) hclust(datos2, method="average")
heatmap.2(datos2, scale = "none", col = bluered(100), 
          xlab ="Taxones de Efemerpteros", 
          ylab= "TRamos del Ro", main = "Caracterizacin de Tramos",
          trace = "none", density.info = "none",distfun = vegdist,
          margins=c(6,5), hclustfun=hclust.ave)